<?php
require_once 'admin_config.php';
requireAdminAuth(); // Ensure only admins can access this page

$message = '';
$message_type = '';

if (isset($_GET['id']) && isset($_GET['status'])) {
    $order_id = intval($_GET['id']);
    $new_status = trim($_GET['status']);

    // Validate the status
    $allowed_statuses = ['pending', 'completed', 'cancelled'];
    if (!in_array($new_status, $allowed_statuses)) {
        $message = 'حالة غير صالحة.';
        $message_type = 'danger';
    } else {
        try {
            $conn = getAdminDBConnection();

            // Update the order status
            $stmt = $conn->prepare("UPDATE orders SET status = ? WHERE id = ?");
            if ($stmt === false) {
                throw new Exception('Prepare update statement failed: ' . $conn->error);
            }

            $stmt->bind_param('si', $new_status, $order_id);

            if ($stmt->execute()) {
                if ($stmt->affected_rows > 0) {
                    $message = 'تم تحديث حالة الطلب بنجاح!';
                    $message_type = 'success';
                } else {
                    $message = 'لم يتم العثور على الطلب أو لم يتم تغيير الحالة.';
                    $message_type = 'warning';
                }
            } else {
                $message = 'حدث خطأ أثناء تحديث الحالة: ' . $conn->error;
                $message_type = 'danger';
            }
            $stmt->close();
        } catch (Exception $e) {
            $message = 'خطأ: ' . $e->getMessage();
            $message_type = 'danger';
        } finally {
            if (isset($conn) && $conn) {
                $conn->close();
            }
        }
    }
} else {
    $message = 'معرف الطلب أو الحالة غير متوفرين.';
    $message_type = 'danger';
}

header('Location: admin_orders.php?message=' . urlencode($message) . '&type=' . $message_type);
exit();
?> 